/*
 Demetris Christodoulou
 demetris.christodoulou@sydney.edu.au
 Graph Workflow ©
 www.graphworkflow.com
*/


version 15
cd "/Users/dchristodoulou/Documents/graphworklfow/graphs/australia_ageing_pop"
graph set window fontface "Avenir"
graph set window fontfaceserif "Palatino"
set scheme s1color

clear all
import excel australia_ageing_pop.xlsx, firstrow

// data management
rename year date
generate year = year(date)
drop date

reshape long Male Female, i(year) j(age)

recode age (0/14 = 1)  (15/64 = 2) (65/max = 3), generate(age3)
bysort year age3: egen pop = total(Male+Female)
egen tag = tag(year age3)
drop if !tag
drop age tag Male Female

bysort year: egen pop_tot = total(pop)

reshape wide pop pop_tot, i(year) j(age3)

generate pop_cump_1 = (pop1 / pop_tot1)
generate pop_cump_2 = (pop2 / pop_tot2)  + pop_cump_1
generate pop_cump_3 = (pop3 / pop_tot3)  + pop_cump_2

// first pass
*twoway (area pop_cump_3 year) (area pop_cump_2 year) (area pop_cump_1 year, base(0))
*graph export australia_ageing_pop_default.png,replace

// predict the trend
set obs `=_N+(2042-2017)'
sort year
replace year = year[_n-1]+1 if year==.
generate t = _n
forvalues i = 1/3 {
   qui reg pop_cump_`i' (c.t##c.t)##c.t
   predict xb, xb
   replace pop_cump_`i' = xb if pop_cump_`i'==.
   drop xb
}


// data management
foreach i of numlist 1/2 {
   local ylab1_pop `ylab1_pop' `=pop_cump_`i'[1]'  "{stSerif:`:di %04.3f `=pop_cump_`i'[1]''}" // 1971
   local ylab2_pop `ylab2_pop' `=pop_cump_`i'[_N]' "{stSerif:`:di %04.3f `=pop_cump_`i'[_N]''}" // 2017
}

local gopt base(0) lcolor(gs16)
local mopt ms(i) mlabpos(9) mlabsize(*.75) mlabc(gs2)
twoway (area pop_cump_3  year, fcolor("227 74 51") `gopt' yaxis(1 2)) ///
       (area pop_cump_2  year, fcolor("252 141 89") `gopt') ///
       (area pop_cump_1  year, fcolor("253 204 138") `gopt') ///
       (scatteri 0.90 2042 "65+ years old", `mopt') ///
       (scatteri 0.50 2042 "16 - 64 years old", `mopt') ///
       (scatteri 0.08 2042 "0 - 14 years old", `mopt') ///
	   (scatteri 0 2017 1 2017 1 2042 0 2042, recast(area) lc(gs16) fc(gs15%30)) ///
       , legend(off) ysize(8) xsize(13) ///
        title("Australia's ageing working population: 1971-2016, projected to 2042",  pos(11) margin(b+2 t+2) size(*.7) c(gs4)) ///
        note("{stSerif:Data Source: the Australian Bureau of Statistics, Australian Demographic Statistics, Jun 2017, Table 59.}", size(*.75) margin(t+2) c(gs4)) ///
        xlabel(1971 "{space 16}{stSerif:{it:from 1971 ...}}" ///
		       2017 "{space 25}{stSerif:{it:to 2017, and projected to ...}}" ///
			   2042 "{stSerif:{it:2042}}", labsize(*.75) noticks) ///
        ylabel(0.02 "{stSerif:0}" `ylab1_pop' .99 "{stSerif:1}", angle(0) format(%04.3f) labsize(*.7) noticks) ///
        ylabel(0.02 "{stSerif:0}" `ylab2_pop' .99 "{stSerif:1}", angle(0) format(%04.3f) labsize(*.7) noticks axis(2)) ///
        plotregion(margin(l=0 t=.2 b=0 r=.2) lc(none) lw(*1.5)) ///
        graphregion(margin(l=2 t=2 b=2 r=0) lc(gs8) lw(*.5)) ///
	    yscale(lc(none) axis(1)) yscale(lc(none) axis(2)) ///
      	xscale(lc(none)) xtitle("") ///
        graphregion(margin(r+5)) ///
        ytitle("Cumulative percentage", size(*.85) c(gs4))
graph export australia_ageing_pop.png,replace


exit
