/*
 Demetris Christodoulou
 demetris.christodoulou@sydney.edu.au
 Graph Workflow ©
 www.graphworkflow.com
*/

version 15
cd "/Users/dchristodoulou/Documents/research/graphworklfow.com/graphs/collaborative_economy"
clear
graph set window fontface "Avenir"
graph set window fontfaceserif "Palatino"

input year transaction platform
2013	10.2	1.0
2014	15.9	1.8
2015	28.1	3.6
end
rename transaction tr
rename platform pl

// data management
generate tr2pl = tr/pl


// First Graph Objective
graph set window fontface "BodoniFLF"
local quote1 "The platform revenue in the collaborative economy"
local quote2 "has increased from €{bf:1bn} to €{bf:3.6bn} during 2013-2015"
local sopt ms(i) mlabpos(0) mlabc("114 24 23") mlabsize(*7) 
twoway (scatteri 1.07 1.0 "`quote1'", `sopt') ///
       (scatteri 0.93 1.0 "`quote2'", `sopt') ///
       , legend(off) ysize(1) xsize(5) ///
	   yscale(lc(none) range(0.7 1.3)) xscale(lc(none) range(0 2)) ///
	   xlabel(none) ylabel(none) xtitle("") ytitle("") ///
	   plotregion(lc("114 24 23") fc("207 223 206*.5") lw(*3) margin(none)) ///
	   graphregion(lc("114 24 23") fc("207 223 206*.5") lw(*3) margin(b=1 t=2 l=1 r=2))
graph export collaborative_quote.png,replace


// Second Graph Objective

// first pass using Stata's defaults
twoway (bar tr year) (connected tr2pl year), scheme(s1color) 
graph export collaborative_default.png,replace

// graph management
graph set window fontface "Avenir"
generate tr2pl_lab = strofreal(tr2pl,"%3.1f")
twoway (bar tr year, barw(.25) fc("138 162 158") lc("138 162 158")) ///
       (scatter tr year, ms(i) mlab(tr) mlabc(gs16) mlabpos(6) mlabsize(*1)) ///
       (connected tr2pl year, lw(*3) lc("148 93 94") mlc("148 93 94") mlabsize(*1) ///
	              mfc(gs16) mlw(*2) mlab(tr2pl_lab) mlabpos(12) mlabc("148 93 94") mlabgap(2)) ///
	   , ysize(1) xsize(1) ///
	   yscale(range(0 28.1) lc(none)) ///
	   ylabel(0 " " 0.2 "0",angle(0) noticks labc(gs8) labsize(*.75)) ytitle("") ///
	   xscale(lc(none)) xtitle("") ///
	   xlabel(2013/2015, noticks labc(gs8) labsize(*.75)) ///
	   title("Figure 3: Transaction value facilitated by collaborative economy", size(*.65) pos(11) margin(b+2)) ///
	   note("{stSerif:Source: What could have been PwC analysis.}", size(*.85) pos(7) margin(t+2)) ///
	   plotregion(lc(gs8) lw(*.5) margin(b=0 r=4 l=4 t=4)) ///
	   graphregion(lc(gs8) lw(*.5) margin(r+2)) ///
	   legend(order(1 3) col(1) pos(11) ring(0) symxsiz(5) symysiz(2.5) bmargin(t=4) ///
	          label(1 "€bn in transactions") label(3 "€bn in transactions per €1bn of platform revenue") ///
	          size(*.65) region(lc(none) margin(none)))
gr_edit title.text[2]=`"platforms in Europe, 2013-2015"'
graph export collaborative_transactions.png,replace


exit
