/*
 Demetris Christodoulou
 demetris.christodoulou@sydney.edu.au
 Graph Workflow ©
 www.graphworkflow.com
*/

version 15
cd "/Users/dchristodoulou/Documents/graphworklfow/graphs/height_countries"
graph set window fontface "Avenir"
graph set window fontfaceserif "Palatino"
graph set window fontfacesans "Eurostile"
set scheme s1color


clear
*import delimited height_countries.csv
*save height_countries,replace
use height_countries
rename sex gender
rename yearofbirth year
rename meanheightcm hei
rename meanheightlower95uncertaintyinte hei_lo
rename meanheightupper95uncertaintyinte hei_hi

// change every 50 years
keep if inlist(year,1896,1946,1996)

// focus on one gender class; specify "Men" or "Women"
local gclass "Women"
keep if gender=="`gclass'"

keep country year hei
reshape wide hei, i(country) j(year)
gsort -hei1896
generate id = _n

// reduce country names
replace country = "Bosnia & Herzegovina" if country=="Bosnia and Herzegovina"
replace country = "USA" if country=="United States of America"
replace country = "St.Vincent & Grenadines" if country=="Saint Vincent and the Grenadines"
replace country = "St.Kitts and Nevis" if country=="Saint Kitts and Nevis"
replace country = "Palestinian Territory" if country=="Occupied Palestinian Territory"
replace country = "Micronesia" if country=="Micronesia (Federated States of)"

// ylabels; add 0.2 to align properly
local lablist ""
forval i = 1/`=_N' {
   local lablist `lablist' `=`i'+0.2' "`=country[`i']'"
}

// yticks
local ticlist ""
forvalues i = 1/`=_N' {
   if mod(`i',2)==0 local ticlist `ticlist' `i'
}
di "`ticlist'"

// xlabels
scalar hei_min = 200
scalar hei_max = 0
foreach i of varlist hei1896 hei1946 hei1996 {
   qui sum `i'
   scalar hei_min = min(r(min),hei_min)
   scalar hei_max = max(r(max),hei_max)
}

// plot options
local popt_up ms(|) mc("92  147 175") msize(*.5) lc("92  147 175") mlw(*.1) lw(*.5)
local popt_dn ms(|) mc("232 118 123") msize(*.5) lc("232 118 123") mlw(*.1) lw(*.5)
local sopt_up ms(i) mlabc("92  147 175") mlabsize(*.45) mlabgap(.5)
local sopt_dn ms(i) mlabc("232 118 123") mlabsize(*.45) mlabgap(.5)

local plist ""
local slist ""
forval i = 1/`=_N' {
   if hei1946[`i']>hei1896[`i'] {
      local plist `plist' (scatteri `i' `=hei1896[`i']' `i' `=hei1946[`i']', `popt_up' recast(line))
	  local slist `slist' (scatteri `i' `=hei1896[`i']' "`:di %4.1f `=hei1896[`i']''", `sopt_up' mlabpos(9))
   }
   if hei1996[`i']>hei1946[`i'] {
      local plist `plist' (scatteri `i' `=hei1946[`i']' `i' `=hei1996[`i']', `popt_up' recast(line))
	  local plist `plist' (scatteri `i' `=hei1996[`i']' `i' `=hei1996[`i']', `popt_up' recast(line) lw(*1.75))
	  local slist `slist' (scatteri `i' `=hei1996[`i']' "`:di %4.1f `=hei1996[`i']''", `sopt_up' mlabpos(3))
   }
   if hei1996[`i']<hei1946[`i'] {
      local plist `plist' (scatteri `i' `=hei1946[`i']' `i' `=hei1996[`i']', `popt_dn' recast(line))
	  local plist `plist' (scatteri `i' `=hei1996[`i']' `i' `=hei1996[`i']', `popt_dn' recast(line) lw(*1.75))
	  local slist `slist' (scatteri `i' `=hei1946[`i']' "`:di %4.1f `=hei1996[`i']''", `sopt_dn' mlabpos(3))
   }
}

twoway (connected id hei1896 if id==0, `popt_up') ///
	   (connected id hei1896 if id==0, `popt_dn') ///
	   (scatter   id hei1996 if id==0, ms(o) msize(*.1) mlw(*.1) mc("92  147 175")) ///
       (scatter   id hei1946 if hei1946>hei1896, `popt_up') ///
       (scatter   id hei1946 if hei1996>hei1946, `popt_up') ///
	   (scatter   id hei1946 if hei1996<hei1946, `popt_dn') ///
	   `plist' `slist', ///
       ylabel(`lablist', angle(0) labsize(*.6) noticks labgap(1) labc(gs4)) ///
	   plotregion(lc(none) margin(l=5 r=5 t=0 b=2) fc(gs16)) ///
	   graphregion(lc(none) margin(l=7 r=1 t=2 b=2) fc(gs16)) ///
	   ytitle("") xtitle("") ///
	   yscale(lc(none)) xscale(off) ///
	   yticks(`ticlist', noticks grid gmax gmin glw(*6) glc(gs15)) ///
	   note("Data source: http://www.ncdrisc.org/data-downloads-height.html", color(gs4) margin(t+2) size(*.85)) ///
	   title("`gclass''s average height at age 18: 1896 {&rarr} 1946 {&rarr} 1996", margin(t=2 b=2 l=2 r=10) c(gs2) pos(12) size(*.75)) ///
	   legend(span order(1 2 3) row(1) pos(12) ring(1) region(lc(none) margin(none)) ///
	          bmargin(t=2 b=4 r=4 l=10) symxsize(*.5) size(*.75) color(gs4) colgap(10) ///
	          label(1 "Increase") ///
			  label(2 "Decrease from 1946 to 1996") ///
			  label(3 "1996")) ///
	   ysize(4) xsize(1)
graph export height_countries.png, replace height(4000) width(1000)

exit

Data source: http://www.ncdrisc.org/data-downloads-height.html
