/*
 Demetris Christodoulou
 demetris.christodoulou@sydney.edu.au
 Graph Workflow ©
 www.graphworkflow.com
*/


version 15
cd "/Users/dchristodoulou/Documents/graphworklfow/graphs/labour_participation"
graph set window fontface "Palatino"
graph set window fontfaceserif "Palatino"
set scheme s1color
clear all

clear
import delimited using hdi.csv
destring hdi*, replace force
reshape long hdi, i(countrycode countryname) j(year)
labe var hdi "HDI index for 2017"
drop countryname
merge 1:1 countrycode year using labour_participation
drop _merge

keep if !missing(countrycode,year,male,female,hdi)
keep if inrange(year,1990,2017)

replace female = female/100
replace male = male/100

// Top 25 HDI vs Bottom 25 HDI
preserve
 keep if year==2017
 keep countrycode hdi
 drop if inlist(countrycode,"AFG","SYR","YEM","IRQ","SSD","LBY","MMR","MLI") // high risk from smartraveller.gov.au - do not travel 
 drop if inlist(countrycode,"BFA","MRT","NER","NGA","TCD","CAF","SDN","COD") // high risk from smartraveller.gov.au - do not travel 
 drop if inlist(countrycode,"ATH","VEN","PAK") // high risk from smartraveller.gov.au - do not travel 
 drop if inlist(countrycode,"DZA","EGY","ERI","DJI","CIV","HTI","COG","COL") // high risk from smartraveller.gov.au - reconsider travel
 drop if inlist(countrycode,"IRN","SAU","GMB","GNQ") // high risk from smartraveller.gov.au - reconsider travel
 sort hdi
 levelsof countrycode in 1/25, local(hid_lo) clean
 levelsof countrycode in -25/L, local(hid_hi) clean
restore

local yx "female male"
local lopt connect(year) msymbol(i) lpattern(solid) lwidth(*.2) // line plot
local sopt msymbol(o) msize(*.75) mlw(*.2) //mlab(countrycode) mlabsize(*.5) // ending year coordinate
local c1 "247 129 77" // hid_hi
local c2 "68  94 147" // hid_lo
local col1 lc("`c1'*1.25") mlc("`c1'*1.25") mfc("`c1'%50")
local col2 lc("`c2'*.8") mlc("`c2'*.8") mfc("`c2'%25")

foreach i of local hid_lo { 
   quietly summarize year if countrycode=="`i'"
   local ymin = r(min)
   local ymax = r(max)
   local slist         (scatter `yx' if countrycode=="`i'", `lopt' `col2')
   local slist `slist' (scatter `yx' if countrycode=="`i'" & year==`ymax', `sopt' `col2')
   local scatterlist `scatterlist' `slist'
}

foreach i of local hid_hi { 
   quietly summarize year if countrycode=="`i'"
   local ymin = r(min)
   local ymax = r(max)
   local slist         (scatter `yx' if countrycode=="`i'", `lopt' `col1')
   local slist `slist' (scatter `yx' if countrycode=="`i'" & year==`ymax', `sopt' `col1')
   local scatterlist `scatterlist' `slist'
}


twoway (scatter `yx' if year==0, `s1opt' lwidth(*1) lcolor("`c1'") `sopt' `col1' msize(*1.25)) ///
       (scatter `yx' if year==0, `s1opt' lwidth(*1) lcolor("`c2'") `sopt' `col2' msize(*1.25)) ///
	   `scatterlist' ///
       , aspect(1) ysize(1.2) xsize(1) ///
	   xlabel(0 "0" .1(.1).9 1 "1", grid format(%3.1f) glw(*.2) labsize(*.6) labc(gs6) tl(*.5) tlw(*.3)) ///
	   ylabel(0 "0" .1(.1).9 1 "1", grid format(%3.1f) glw(*.2) labsize(*.6) labc(gs6) tl(*.5) tlw(*.3) angle(0)) ///
       plotregion(margin(none) lcolor(gs0) lw(*.5)) graphregion(lcolor(gs0) lw(*.5)) ///
	   yscale(lc(none))xscale(lc(none)) ///
	   legend(order(1 2) row(1) size(*.75) region(lc(none) fc(none)) ///
	          ring(1) pos(12) rowgap(*.1) bmargin(b=1 t=1) margin(none)  ///
	          label(1 "Top 25 HID countries") label(2 "Bottom 25 HID countries")) ///
       ytitle("Female labor participation (+15 years of age)", margin(r+2) size(*.7) c(gs4)) ///
       xtitle("Male labor participation (+15 years of age)", margin(t+2) size(*.7) c(gs4)) ///
       title("Labour equality journey to improved human development, 2017", size(*.65) margin(b=1 t=1) c(gs2) span) ///
       note("{stSerif:Note: Labour data from World Bank. Human Development Index (HDI) from UN Development Programme.}" ///
	        "{stSerif:Lines show the labour participation path from 1990 to 2017 as indicated by the circle markers 'o'.}", c(gs4) size(*.7) pos(7) margin(t+2))

graph export labour_participation.png, replace

exit

Data Sources:
https://data.worldbank.org/indicator/SL.TLF.CACT.MA.ZS // male
https://data.worldbank.org/indicator/SL.TLF.CACT.FE.ZS // female
http://hdr.undp.org/en/indicators/137506 // HDI index
