/*
 Demetris Christodoulou
 demetris.christodoulou@sydney.edu.au
 Graph Workflow ©
 www.graphworkflow.com
*/


version 15
cd "/Users/dchristodoulou/Documents/research/graphworklfow.com/graphs/marginal_tax_rates"
graph set window fontface "Avenir"
graph set window fontfaceserif "Palatino"

// input data from https://stats.oecd.org and ISO codes
clear
input str30 country str2 ccode inc_tax inc_tax_soc_sec top_tax_rate threshold av_wage_cur av_wage_usd
Australia		AU	49.0 	49.0 	49.0 	2.2 	83542.0 	55098.7 
Austria			AT	48.0 	48.0 	48.0 	7.9 	45976.8 	57580.8 
Belgium			BE	46.0 	60.2 	52.9 	1.0 	47324.3 	58545.1 
Canada			CA	53.5 	53.5 	53.5 	4.3 	51642.5 	40983.3 
Chile			CL	35.0 	35.0 	35.0 	7.7 	9349964.0 	22615.9 
Czechia			CZ	20.1 	31.1 	15.0 	0.3 	355149.7 	27535.8 
Denmark			DK	55.8 	55.8 	55.8 	1.3 	413503.1 	56210.9 
Estonia			EE	19.7 	21.3 	20.0 	0.1 	14809.9 	26795.9 
Finland			FI	49.0 	58.3 	51.4 	1.9 	43986.1 	49012.6 
France			FR	53.9 	55.1 	54.5 	14.6 	38582.1 	48339.2 
Germany			DE	47.5 	47.5 	47.5 	5.4 	49450.0 	63551.0 
Greece			GR	55.0 	55.0 	54.0 	3.9 	20886.4 	35165.1 
Hungary			HU	15.0 	33.5 	15.0 	0.0 	3578650.8 	26012.2 
Iceland			IS	44.4 	44.4 	46.2 	1.2 	8903714.4 	63660.6 
Ireland			IR	48.0 	52.0 	48.0 	1.9 	36358.1 	45093.0 
Israel			IL	50.0 	50.0 	50.0 	4.3 	147983.5 	39215.2 
Italy			IT	42.3 	52.8 	47.2 	2.7 	30838.2 	43304.2 
Japan			JP	55.8 	56.1 	55.9 	8.5 	5201390.7 	52946.0 
Korea			KR	39.3 	43.2 	41.8 	3.8 	46140295.7 	52505.3 
Latvia			LV	10.9 	21.4 	23.0 	0.1 	10904.8 	21755.0 
Luxembourg		LU	41.4 	42.8 	41.4 	2.8 	58564.7 	65716.3 
Mexico			MX	35.0 	35.0 	35.0 	25.4 	118203.6 	12730.0 
Netherlands		NL	49.7 	52.3 	52.0 	1.4 	50908.5 	62981.1 
"New Zealand"	NZ	33.0 	33.0 	33.0 	1.2 	58824.0 	39826.3 
Norway			NO	38.5 	46.7 	38.5 	1.6 	577664.4 	56400.7 
Poland			PL	22.1 	39.9 	32.0 	2.0 	49569.7 	27816.3 
Portugal		PT	50.0 	61.0 	56.2 	15.6 	17993.0 	30888.5 
Slovakia		SK	21.7 	35.1 	25.0 	3.5 	11425.6 	23484.0 
Slovenia		SI	39.0 	61.1 	50.0 	5.0 	18903.8 	31417.2 
Spain			ES	43.5 	43.5 	43.5 	2.4 	26534.7 	40451.4 
Sweden			SE	60.1 	60.1 	57.1 	1.5 	434858.8 	47657.6 
Switzerland		SW	36.1 	41.7 	41.7 	3.5 	86041.9 	70835.1 
Turkey			TR	30.5 	45.5 	35.8 	3.2 	40308.0 	29263.0 
"United Kingdom" UK	45.0 	47.0 	45.0 	3.9 	38208.1 	54318.9 
"United States"	US	46.3 	48.6 	46.3 	8.0 	52988.0 	52988.0 
end
compress
save marginal_tax_rates, replace

clear
use marginal_tax_rates
generate inv_threshold =1/threshold

replace top_tax_rate = 47 if country=="Australia"

//first pass
scatter top_tax_rate threshold, mlab(country)
graph export marginal_tax_rates_default.png,replace

*list if inv_threshold>1
keep if inv_threshold<=1

quietly summarize top_tax_rate
scalar ymin = r(min)
scalar ymax = r(max)
quietly summarize inv_threshold
scalar xmin = r(min)
scalar xmax = r(max)
quietly summarize top_tax_rate if country=="Australia"
scalar y1 = r(min)
quietly summarize inv_threshold if country=="Australia"
scalar x1 = r(min)
quietly summarize av_wage_cur if country=="Australia"
scalar x2024 = (r(mean)*(1.021)^6) / 200000
scalar y2024 = 45

local sop1 ms(O) msize(*2) mlc(gs0) mlab(ccode)
local sop1 `sop1' mlabpos(0) mlw(*.25) mlabsize(*.65) 
local sop2 mfc(gs14%20) mlabc(gs0)
local yx top_tax_rate inv_threshold
twoway (scatteri `=y1' `=x1' `=y2024' `=x2024', recast(line) lw(*.5)) ///
	   (scatteri `=y2024' `=x2024' "2024 projection", `sop1' msize(*.6) mlc(gs4) mfc(gs4) mlabpos(3) mlabsize(*.5)) ///
	   (scatter `yx' if country!="Australia", `sop1' `sop2') ///
       (scatter `yx' if country=="Australia", `sop1' mlw(*1) mlc(gs4) mfc(gs4) mlabc(gs16)) ///
	   , leg(off) ysize(1) xsize(1.75) scheme(s1mono) ///
	   ytitle("Top marginal tax rate (%)", size(*.75) margin(b+2)) ///
	   xtitle("Average wage relative to top threshold", size(*.75) margin(t+2)) ///
	   ylabel(`=ymin' `=ymax' `=y1', labsize(*.65) angle(0) format(%3.1f) grid glw(*.5) noticks) ///
	   xlabel(`=xmin' `=xmax' `=x1', labsize(*.65) angle(0) format(%3.2f) grid glw(*.5) noticks) ///
	   yscale(lc(none)) xscale(lc(none)) ///
	   plotregion(lc(none) margin(l=5 b=5 r=3 t=3)) ///
	   graphregion(lc(gs8) lwidth(*.5)) ///
	   title("Chart 2: Top marginal tax rates and top thresholds, OECD countries, 2017", size(*.7) pos(11) margin(b+2)) ///
	   note("{stSerif:Note: Data sourced from the 2017 OECD Revenue Statistics and Tax Database. The graph excludes three OECD countries with low top marginal rates and high average wage to top thresholds. These are Czechia (15, 3.33),}" ///
	        "{stSerif:Estonia (23, 10), Hungary (15,flat) and Latvia (20, 10), where in parenthesis are the {it:yx} coordinates. The 2024 projection is based on the proposed 45% top rate and a compounded average wage at 2.1% growth per annum.}", size(*.63))
graph export marginal_tax_rates.png,replace

exit

Graph source: https://www.budget.gov.au/2018-19/content/bp1/download/BP1_full.pdf
Data source: https://stats.oecd.org/index.aspx?DataSetCode=TABLE_I7
ISO codes: https://en.wikipedia.org/wiki/ISO_3166-1
