/*
 Demetris Christodoulou
 demetris.christodoulou@sydney.edu.au
 Graph Workflow ©
 www.graphworkflow.com
*/


versio 15
cd "/Users/dchristodoulou/Documents/research/graphworklfow.com/graphs/military_spending_rotation"
graph set window fontface "Avenir"
graph set window fontfaceserif "Palatino"

clear
use military_spending

replace  military = military*1000000
generate mil2gdp = military/GDP_current_USD * 100
drop military GDP_current_USD
encode jurisdiction, gen(jur_id)
drop jurisdiction
reshape wide mil2gdp, i(year) j(jur_id)
rename mil2gdp1 eu
rename mil2gdp2 ru

// rotate coordinates
scalar theta = _pi/4
generate eu_rot = eu*cos(theta) - ru*sin(theta)
generate ru_rot = eu*sin(theta) + ru*cos(theta)

// first pass graph
twoway (connected ru eu) (connected ru_rot eu_rot), scheme(s2color)
*graph export military_spending_rotation_default.png,replace

// graph management 
local slist ""
local llist ""
local si1 recast(line) lc(gs14) lw(*.35)
local si2 ms(i) mlabsize(*.55)
forvalues i = 0(0.5)9 {
   scalar x1 = `i'*cos(theta) - 0*sin(theta)
   scalar y1 = `i'*sin(theta) + 0*cos(theta)
   scalar x2 = `i'*cos(theta) - 9*sin(theta)
   scalar y2 = `i'*sin(theta) + 9*cos(theta)
   scalar x3 =   0*cos(theta) - `i'*sin(theta)
   scalar y3 =   0*sin(theta) + `i'*cos(theta)
   scalar x4 =   9*cos(theta) - `i'*sin(theta)
   scalar y4 =   9*sin(theta) + `i'*cos(theta)
   local slist "`slist' (scatteri `=y1' `=x1' `=y2' `=x2', `si1')"
   local slist "`slist' (scatteri `=y3' `=x3' `=y4' `=x4', `si1')"
   local llist "`llist' (scatteri `=y1' `=x1' "`:di %3.1f `i''", `si2' mlabangle(-45) )"
   local llist "`llist' (scatteri `=y3' `=x3' "`:di %3.1f `i''", `si2' mlabangle(45) mlabpos(9))"
}

twoway `slist' `llist' ///
       (scatteri 0 0 `=2*9*cos(theta)' 0, recast(line) lc(gs8) lw(*1)) ///
       (scatteri 1.6 2.5 "{bf:European NATO} military spending", ms(i) mlabsize(*.8) mlabc(gs4) mlabangle(45)) ///
       (scatteri 5.4 -7.1 "{bf:Russia} military spending", ms(i) mlabsize(*.8) mlabc(gs4) mlabangle(135) mlabpos(3)) ///
       (scatteri `=5.8*sin(theta) + 5.8*cos(theta)' 0 "{stSerif:{it:balancing line of equal spending}}", ms(i) mlabsize(*.75) mlabc(gs8) mlabangle(90) mlabpos(1) mlabgap(-2)) ///
       (function y = x, range(0 `=9*cos(theta)') lc(gs8) lw(*1)) ///
       (function y = -x, range(`=-9*cos(theta)' 0) lc(gs8) lw(*1)) ///
       (connected ru_rot eu_rot, lp(solid) lw(*1) mlw(*1) lcolor(navy) ///
        msize(*1) ms(o) mlc(navy) mfc(gs16)) ///
       (scatter ru_rot eu_rot if inlist(year,1993,2017), msize(*1.2) mlab(year) mlabgap(1.2) ///
        ms(o) mlc(navy) mlabc(navy*1.25) mfc(orange%50) mlw(*.75) mlabpos(3) mlabsiz(*.5)) ///
       , scheme(s1mono) legend(off) ysize(1) xsize(1.1) aspect(1) ///
	   title("Russia tipping the scale of military spending (as % of GDP) to its favour" "by comparison to European NATO", size(*.65) margin(b+2)) ///
	   xtitle("") ytitle("") xlabel(none) ylabel(none) yscale(off) xscale(off) ///
	   plotregion(margin(none) lc(none)) ///
	   graphregion(lc(gs8) lw(*.5))
graph export military_spending_rotation.png,replace

exit
	   
Sources: 
https://data.worldbank.org/indicator/NY.GDP.MKTP.CD?locations=EU
https://www.sipri.org/sites/default/files/1_Data%20for%20all%20countries%20from%201988%E2%80%932017%20in%20constant%20%282016%29%20USD.pdf
