/*
 Demetris Christodoulou
 demetris.christodoulou@sydney.edu.au
 Graph Workflow ©
 www.graphworkflow.com
*/

version 15
cd "/Users/dchristodoulou/Documents/graphworklfow/graphs/nba"
set scheme s1mono
graph set window fontface "Avenir"
graph set window fontfaceserif "Minion Pro"

clear
use nba

encode shot_result, gen(shr)
encode player_name, gen(player)
rename shot_clock  shc
rename dribbles    dri
rename touch_time  tou
rename shot_dist   shd
rename close_def_dist def
keep player shr shc tou shd dri  def

tab player shr

drop if tou<0 // one nonsense observation
drop if shd>30 
drop if def>11


forval i = 1/10 {
   generate x`i' = `i'
}
scalar ymin =0
scalar ymax =0
foreach i of varlist shc tou shd dri  def {
   qui sum `i'
   replace `i' = `i'/r(max)
   qui sum `i'
   if ymin > r(min) scalar ymin = r(min)
   if ymax < r(max) scalar ymax = r(max)
}

cou if player==1 & shr==1
scalar lj_shots_made = r(N)
cou if player==1 & shr==2
scalar lj_shots_miss = r(N)

cou if player==2 & shr==1
scalar sc_shots_made = r(N)
cou if player==2 & shr==2
scalar sc_shots_miss = r(N)

local c1 255 245  33 //255 231  76
local c2 0   166 237 //1   253 246
local lopt yaxis(1 2) lw(*.2)

local name1 LeBron James
local name2 Stephen Curry
local lab1 lj 
local lab2 sc

local c 0

forvalues i = 1/2 {

twoway /// legend
       (pcspike shc x1 tou x2 if player==0, lw(*2) lc("`c1'"))   /// made
	   (pcspike shc x1 tou x3 if player==0, lw(*2) lc("`c2'"))   /// missed
	   /// shots made
	   (pcspike shc x1 tou x2 if shr==1 & player==`i', `lopt' lc("`c1'%20")) ///
       (pcspike tou x2 dri x3 if shr==1 & player==`i', `lopt' lc("`c1'%20")) ///
	   (pcspike dri x3 def x4 if shr==1 & player==`i', `lopt' lc("`c1'%20")) ///
	   (pcspike def x4 shd x5 if shr==1 & player==`i', `lopt' lc("`c1'%20")) ///
	   /// shots missed
	   (pcspike shc x1 tou x2 if shr==2 & player==`i', `lopt' lc("`c2'%20"))  ///
       (pcspike tou x2 dri x3 if shr==2 & player==`i', `lopt' lc("`c2'%20"))  ///
	   (pcspike dri x3 def x4 if shr==2 & player==`i', `lopt' lc("`c2'%20"))  ///
	   (pcspike def x4 shd x5 if shr==2 & player==`i', `lopt' lc("`c2'%20"))  ///
	   , ysize(1) xsize(1.75) ///
	   plotregion(lc(gs2) fc(gs2) margin(none)) ///
	   graphregion(lc(gs0) fc(gs2)) ///
	   xscale(lc(none)) xtitle("") ///
	   yscale(lc(none)) ytitle("", axis(1)) ytitle("", axis(2)) ///
	   xlabel(1 "Shot clock" 2 "Touch time" 3 "Dribbles" 4 "Defender distance" ///
	          5 "Shot distance", labc(gs13) labgap(*6) labsize(*.75) noticks) ///
	   ylabel(`=ymin' "Zero" `=ymax' "Max", labc(gs13) labgap(*2) angle(0) axis(1) tlw(*1.5) labsize(*.75)) ///
	   ylabel(`=ymin' "Zero" `=ymax' "Max", labc(gs13) labgap(*2) angle(0) axis(2) tlw(*1.5) labsize(*.75)) ///
	   xline(1/5, lc(gs0) lw(*1.5)) ///
	   title("NBA shots taken by `name`i''", c(gs13) size(*.7) pos(11) ring(2) margin(b=0)) ///
	   subtitle("2014/2015 season", c(gs13) size(*.7) pos(11) ring(1)) ///
	   note("Data source: nba.com API.", color(gs13) size(*.8) ring(1) margin(t+2)) ///
	   legend(color(gs13) order(1 2) symxsize(*.3) row(1) ring(1) pos(1)  ///
	          region(lc(gs2) fc(gs2) margin(b=5 t=3 r=0)) bmargin(r=0) size(*.75) ///
	          label(1 "Shots made (`=`lab`i''_shots_made' shots)") ///
			  label(2 "Shots missed (`=`lab`i''_shots_miss' shots)"))
graph export nba_`++c'.png, replace	   

}


exit
