/*
 Demetris Christodoulou
 demetris.christodoulou@sydney.edu.au
 Graph Workflow ©
 www.graphworkflow.com
*/

version 15
cd "/Users/dchristodoulou/Documents/graphworklfow/graphs/ratio_normal"

set scheme s1mono
set more off

graph set window fontface "Avenir"
graph set window fontfaceserif "Palatino"

clear all

drawnorm y1-y2, n(20000) clear seed(54321)
summarize
generate c1 = y1/y2
local n 0
forvalues v = 2(2)12 {
	generate r`++n' = (6 * 1/3 + y1)/(`v' * 1/8 + y2)
}

/*
*first-pass
foreach i of varlist y1 r? c1 {
   sort `i'
   gen `i'_x = _n
   local llist `llist' (line `i'_x `i' if inrange(`i',-3,3), sort)
}
twoway `llist', graphregion(lc(gs8) lw(*.5)) scheme(s1color)
graph export marsaglia_default.png,replace
*/

local opt "lwidth(*1.25) sort"
local opt1 "lwidth(*2)"
local opt8 "lwidth(*1.5)"
local llist ""
local colors gs13 dkorange*.2 dkorange*.5 dkorange*.8 dkorange*1 dkorange*1.25 dkorange*1.5 navy
tokenize `colors'
local c 0
foreach i of varlist y1 r? c1 {
   local ++c
   sort `i'
   gen `i'_index = _n
   local llist `llist' (line `i'_index `i' if inrange(`i',-3,3), `opt' `opt`c'' lc(``c''))
}


twoway `llist', ysize(1) xsize(1.5) /// 
		legend(position(11) size(*.7) ring(0) cols(1) symxsize(2) symysize(2) rowgap(*.5) ///
		       region(lc(none)) order(1 8 2 3 4 5 6 7) ///
               label(1 "Standard Normal: N(0,1)")  ///
               label(8 "Cauchy: N(0,1) / N(0,1)")  ///
               label(2 "(6/3 + N(0,1)) / (2/8 + N(0,1))") ///
               label(3 "(6/3 + N(0,1)) / (4/8 + N(0,1))") ///
               label(4 "(6/3 + N(0,1)) / (6/8  + N(0,1))") ///
               label(5 "(6/3 + N(0,1)) / (7/8  + N(0,1))") ///
               label(6 "(6/3 + N(0,1)) / (10/8  + N(0,1))") ///
               label(7 "(6/3 + N(0,1)) / (12/8  + N(0,1))")) ///
        xtitle("") yscale(off) ///
		xline(0, lc(gs12) lw(*.5) lp(dash)) ///
		xlabel(-3(1)3, labsize(*.75)) ///
		plotregion(lc(none) margin(none)) ///
		graphregion(lc(gs8) lw(*.5) margin(medium)) ///
        title("The ratios of Normal distributions are not normally distributed", margin(b+2) size(*.75) pos(11)) ///
        caption("{stSerif:Note: The ratio of two N(0,1) is a Cauchy (Geary 1930). The ratio of two {it:c} + N(0,1) is a Non-normal, even bimodal (Marsaglia 1965).}", size(*.7) margin(t+2))
graph export marsaglia.png,replace

exit
