/*
 Demetris Christodoulou
 demetris.christodoulou@sydney.edu.au
 Graph Workflow ©
 www.graphworkflow.com
*/

version 15
cd "/Users/dchristodoulou/Documents/graphworklfow/graphs/recessions_reference"
graph set window fontface "Avenir"
graph set window fontfaceserif "Garamond"

cd "/Users/dchristodoulou/Documents/graphworklfow/graphs/recessions_reference"

/*
clear
import excel using nber_recessions.xlsx, firstrow
replace peak = "01 "+peak if peak!="." // to match NBER's process of updating usiness cycle estimates at beginning of month
replace trough = "01 "+trough 
generate peakdate = date(peak,"DMY")
generate peakmonth = mofd(peakdate)
generate troughdate = date(trough,"DMY")
generate troughmonth = mofd(troughdate)
drop peakdate troughdate peak trough
format %tmMonth-CCYY *
// Economic contractions start at the peak of a business cycle and end at the trough
keep if !missing(peakmonth,troughmonth)
save nber_recessions, replace
*/

/*
clear
import excel spindex.xls, firstrow
drop if date==.
tostring date, force replace
split date, parse(".")
replace date = date1 + "-" + date2 + "-01" 
generate date3 = date(date,"YMD",2018)
drop date date1 date2
rename date3 date
format %td date
generate month = mofd(date)
format %tmMonth-CCYY month
save spindex, replace
*/

clear all
use spindex
sort date
replace spindex = ln(spindex)/log(2)
*keep if year(date)>=1900 

quietly summarize month
scalar dmin = r(min)
scalar dmax = r(max)
quietly summarize spindex
scalar pmin = round(r(min),.1)
scalar pmax = round(r(max),.1)

generate year = year(date)
generate monthindex = month(date)
preserve
 keep if monthindex == 1 // January
 local xlablist ""
 forvalues i = 1(4)`=_N' { // label every number of years
    local xlablist "`xlablist' `=month[`i']'"
 }
 di "`xlablist'"
restore 

// collect recessions
preserve
 use nber_recessions, clear
 drop if peakmonth<dmin | peakmonth==.
 scalar recessions = _N // number of recessions
 local c 0
 forvalues i = 1/`=_N' {
   local ++c
   scalar peak`c' = peakmonth[`i']
   scalar trough`c' = troughmonth[`i']
 }
restore

// reference areas
local areas ""
local aopt "recast(area) lcolor(red*.2) fcolor(red*.25)"
forvalues i = 1/`=recessions' {
   qui sum spindex if inrange(month,peak`i',trough`i')
   scalar min`i' = r(min)
   scalar max`i' = r(max)
   local area`i' "(function y=`=max`i'', `aopt' base(`=min`i'') range(`=trough`i'' `=peak`i''))"
   local areas "`areas' `area`i''"
}

// reference lines indicating length of recovery
local lines ""
local scats ""
local lopt "recast(line) lcolor(navy*.85) lp(dash) lw(*.65)"
local sopt "ms(i) mlabpos(12) mlabc(navy*.85) mlabsize(*1)"

scalar recoverp0 = 0
forvalues i = 1/`=recessions' {
   qui sum spindex if inrange(month,peak`i'-3,peak`i') // allow up to 2 months in anticipation of the recession
   scalar peakp`i' = r(max)
   qui sum month if month==peak`i'
   scalar peakm`i' = r(mean)
   
   preserve 
    qui keep if month>=peakm`i'+12 // add 12 months to capture only significant drops
    forvalues j = 1/`=_N' {
	   if peakp`i' > recoverp0 { // only if the recession falls in the recovery period of the previous recession
	      if peakp`i'<=spindex[`j'] {
	         scalar recoverp`i' = spindex[`j']
	         scalar recoverm`i' = month[`j']
		     
			 scalar recoverp0 = recoverp`i'
			 
			 scalar period`i' = (recoverm`i' - peakm`i')/12
			 scalar middle`i' = peakm`i' + (recoverm`i' - peakm`i')/2
			 *n di period`i' , middle`i'
			 *n di peakp`i', peakm`i', _newline, recoverp`i', recoverm`i', _newline // check
            
			 if period`i'>1.5 {
			 	local line`i' (scatteri `=peakp`i'' `=peakm`i'' `=recoverp`i'' `=recoverm`i'', `lopt')
                local lines `lines' `line`i''
                local scat`i' `"(scatteri `=peakp`i'' `=middle`i'' "`:di %3.1f `=period`i''' yrs", `sopt')"'
                local scats `" `scats' `scat`i'' "'
			 }

             continue, break // enter this loop only once
	      }
	   }
	}
   restore
}

twoway `areas' `lines' `scats' ///
   (line spindex month, lcolor(gs0) lwidth(*.75)) ///
   , ysize(1) xsize(3) ///
   xtitle("Year (January)", size(*.85) margin(t+2)) ///
   ytitle("Price index (log base 2)", size(*.85) margin(r+2)) ///
   yscale(range(`=pmin' `=pmax') lcolor(none) titlegap(*.1)) ///
   xscale(range(`=dmin' `=dmax')) ///
   ylabel(0(1)`=pmax+0.5', format(%2.0f) grid gmax glw(*.5) glcolor(gs14) labsize(*.65) angle(0) noticks) ///
   xlabel(`xlablist', labsize(*.6) format(%tmCCYY) angle(30)) ///
   plotregion(lcolor(none) margin(b=0 r=2 l=1 t=4)) ///
   graphregion(lcolor(gs0) margin(medium)) ///
   legend(color(gs2) size(*.8) ring(0) pos(4) order(1 30) region(lc(none)) margin(b+1) bmargin(b+1) ///
	      symxsize(3) symysize(3) label(1 "NBER recessions") label(30 "Recovery periods")) ///
   title("S&P Composite index, 1871-2019", margin(b=-2) c(gs4) size(*.9) pos(11)) ///
   note("Note: Price data from http://www.econ.yale.edu/~shiller/data.htm; NBER business cycles from https://www.nber.org/cycles.html. Dashed lines indicate periods of recovery of 1.5 years and more.", margin(l=0) c(gs4) size(*.95))

graph export recessions.png,replace

exit
