/*
 Demetris Christodoulou
 demetris.christodoulou@sydney.edu.au
 Graph Workflow ©
 www.graphworkflow.com
*/

version 15
cd "/Users/dchristodoulou/Documents/graphworklfow/graphs/semiconductor_sales"
graph set window fontface "Avenir"
graph set window fontfaceserif "Garamond"

//first pass
local c 0
twoway (scatteri 0 -.2 `=sqrt(100)' -.2 `=sqrt(100)' `=-sqrt(100)' 0 `=-sqrt(100)' 0 -.2, recast(area)) ///
       (scatteri 0 -.2 `=sqrt(66)'  -.2 `=sqrt(66)'  `=-sqrt(66)'  0 `=-sqrt(66)'  0 -.2, recast(area)) ///
       (scatteri 0 -.2 `=sqrt(55)'  -.2 `=sqrt(55)'  `=-sqrt(55)'  0 `=-sqrt(55)'  0 -.2, recast(area)) ///
       (scatteri 0 -.2 `=sqrt(45)'  -.2 `=sqrt(45)'  `=-sqrt(45)'  0 `=-sqrt(45)'  0 -.2, recast(area)) ///
       (scatteri 0 -.2 `=sqrt(32)'  -.2 `=sqrt(32)'  `=-sqrt(32)'  0 `=-sqrt(32)'  0 -.2, recast(area)) ///
       (scatteri 0 0.2 `=sqrt(100)' 0.2 `=sqrt(100)' `=sqrt(100)'  0 `=sqrt(100)'  0 0.2, recast(area)) ///
       (scatteri 0 0.2 `=sqrt(76)'  0.2 `=sqrt(76)'  `=sqrt(76)'   0 `=sqrt(76)'   0 0.2, recast(area)) ///
       (scatteri 0 0.2 `=sqrt(65)'  0.2 `=sqrt(65)'  `=sqrt(65)'   0 `=sqrt(65)'   0 0.2, recast(area)) ///
       (scatteri 0 0.2 `=sqrt(56)'  0.2 `=sqrt(56)'  `=sqrt(56)'   0 `=sqrt(56)'   0 0.2, recast(area)) ///
       (scatteri 0 0.2 `=sqrt(41)'  0.2 `=sqrt(41)'  `=sqrt(41)'   0 `=sqrt(41)'   0 0.2, recast(area)) ///
	   (scatteri `=sqrt(66)'  -.2 `=sqrt(76)' 0.2, recast(line)) ///
	   (scatteri `=sqrt(55)'  -.2 `=sqrt(65)' 0.2, recast(line)) ///
	   (scatteri `=sqrt(45)'  -.2 `=sqrt(56)' 0.2, recast(line)) ///
	   (scatteri `=sqrt(32)'  -.2 `=sqrt(41)' 0.2, recast(line)) ///
       , leg(off) graphregion(lc(gs0) lw(*.5) fc(gs16))
graph export semiconductor_sales_default.png, replace

exit

local sci1 recast(area) lw(*.25) lc(navy) fc("navy*1%15")
local sci2 recast(area) lw(*.25) lc(navy) fc("navy*1%15")
local sci3 ms(i) mlabpos(4) mlabc(navy) mlabsize(*.85)
local sci4 ms(i) mlabpos(8) mlabc(navy) mlabsize(*.85)
local c 0
twoway (scatteri 0 -.2 `=sqrt(100)' -.2 `=sqrt(100)' `=-sqrt(100)' 0 `=-sqrt(100)' 0 -.2, `sci1') ///
       (scatteri 0 -.2 `=sqrt(66)'  -.2 `=sqrt(66)'  `=-sqrt(66)'  0 `=-sqrt(66)'  0 -.2, `sci1') ///
       (scatteri 0 -.2 `=sqrt(55)'  -.2 `=sqrt(55)'  `=-sqrt(55)'  0 `=-sqrt(55)'  0 -.2, `sci1') ///
       (scatteri 0 -.2 `=sqrt(45)'  -.2 `=sqrt(45)'  `=-sqrt(45)'  0 `=-sqrt(45)'  0 -.2, `sci1') ///
       (scatteri 0 -.2 `=sqrt(32)'  -.2 `=sqrt(32)'  `=-sqrt(32)'  0 `=-sqrt(32)'  0 -.2, `sci1') ///
       (scatteri 0 0.2 `=sqrt(100)' 0.2 `=sqrt(100)' `=sqrt(100)'  0 `=sqrt(100)'  0 0.2, `sci2') ///
       (scatteri 0 0.2 `=sqrt(76)'  0.2 `=sqrt(76)'  `=sqrt(76)'   0 `=sqrt(76)'   0 0.2, `sci2') ///
       (scatteri 0 0.2 `=sqrt(65)'  0.2 `=sqrt(65)'  `=sqrt(65)'   0 `=sqrt(65)'   0 0.2, `sci2') ///
       (scatteri 0 0.2 `=sqrt(56)'  0.2 `=sqrt(56)'  `=sqrt(56)'   0 `=sqrt(56)'   0 0.2, `sci2') ///
       (scatteri 0 0.2 `=sqrt(41)'  0.2 `=sqrt(41)'  `=sqrt(41)'   0 `=sqrt(41)'   0 0.2, `sci2') ///
       (scatteri 0 -.2 "2006", ms(i) mlabc(gs0) mlabpos(10) mlabsize(*.85) mlabgap(*2)) ///
       (scatteri 0 0.2 "2016", ms(i) mlabc(gs0) mlabpos(2) mlabsize(*.85) mlabgap(*2)) ///
       (scatteri `=sqrt(100)' `=-sqrt(100)' "{stSerif:Total market share (US$265.5 billion)}", `sci3') ///
       (scatteri `=sqrt(66)'  `=-sqrt(66)'  "{stSerif:{bf:Top 25} have 66%}", `sci3') ///
       (scatteri `=sqrt(55)'  `=-sqrt(55)'  "{stSerif:{bf:Top 15} have 55%}", `sci3') ///
       (scatteri `=sqrt(45)'  `=-sqrt(45)'  "{stSerif:{bf:Top 10} have 45%}", `sci3') ///
       (scatteri `=sqrt(32)'  `=-sqrt(32)'  "{stSerif:{bf:Top 5} have 32%}",  `sci3') ///
       (scatteri `=sqrt(100)' `=sqrt(100)' "{stSerif:Total market share (US$357.1 billion)}", `sci4') ///
       (scatteri `=sqrt(76)'  `=sqrt(76)'  "{stSerif:{bf:Top 25} have 76%}", `sci4') ///
       (scatteri `=sqrt(65)'  `=sqrt(65)'  "{stSerif:{bf:Top 15} have 65%}", `sci4') ///
       (scatteri `=sqrt(56)'  `=sqrt(56)'  "{stSerif:{bf:Top 10} have 56%}", `sci4') ///
       (scatteri `=sqrt(41)'  `=sqrt(41)'  "{stSerif:{bf:Top 5} have 41%}",  `sci4') ///
	   (scatteri `=sqrt(66)'  -.2 `=sqrt(76)' 0.2, recast(line) lw(*.35) lc(navy)) ///
	   (scatteri `=sqrt(55)'  -.2 `=sqrt(65)' 0.2, recast(line) lw(*.35) lc(navy)) ///
	   (scatteri `=sqrt(45)'  -.2 `=sqrt(56)' 0.2, recast(line) lw(*.35) lc(navy)) ///
	   (scatteri `=sqrt(32)'  -.2 `=sqrt(41)' 0.2, recast(line) lw(*.35) lc(navy)) ///
       , aspect(`=1/2.2') ysize(1.1) xsize(2) leg(off) ///
	   plotregion(lc(gs16) fc(gs16)) ///
	   graphregion(lc(gs0) lw(*.5) fc(gs16)) ///
	   yscale(range(0 10) off) xscale(range(-10 10) off) ylabel(none) ///
	   title("Semiconductor worldwide sales market share, 2006 vs. 2016", margin(b+1) c(gs4) size(*.7)) ///
	   note("Data source: https://electroiq.com/2016/12/five-suppliers-to-hold-41-of-global-semiconductor-marketshare-in-2016/", margin(l+2) c(gs4) size(*.75))
graph export semiconductor_sales.png, replace


exit

Graph source: https://electroiq.com/2016/12/five-suppliers-to-hold-41-of-global-semiconductor-marketshare-in-2016/

clear
input top share2016 share2006
5  41 32
10 56 45
15 65 55
25 76 66
end 
