/*
 Demetris Christodoulou
 demetris.christodoulou@sydney.edu.au
 Graph Workflow ©
 www.graphworkflow.com
*/

version 15
cd "/Users/dchristodoulou/Documents/research/graphworklfow.com/graphs/taiji_cove_killed"
graph set window fontface "Avenir"
graph set window fontfaceserif "Palatino"

clear
use taijicove

// data management
generate total = killed + captured

sort year
generate killed_index = (killed[_n]/killed[1])*1
generate captured_index = (captured[_n]/captured[1])*1
generate ones = 1

// First pass
twoway (rbar captured_index ones year, horizontal) ///
	   (rbar killed_index ones year, horizontal), scheme(lean2)
*graph export taiji_index_default_bars.png,replace
twoway (pcspike captured_index year ones year, horizontal lw(*14)) ///
	   (pcspike killed_index year ones year, horizontal lw(*7)), scheme(lean2)
*graph export taiji_index_default_lines.png,replace

// graph management
tostring killed_index, gen(killed_str) format(%3.2f) force
tostring captured_index, gen(captured_str) format(%3.2f) force

qui sum killed_index
scalar xbound = max(r(max),abs(r(min)))
qui sum captured_index
scalar xbound = max(xbound,r(max),abs(r(min)))

local c1 dkorange*.9
local c2 navy*.8
local sc1 ms(i) mlabgap(1) mlabsize(*.9)
twoway (scatteri 2001 1 "{bf:1}", ms(i) mlabpos(0) mlabsize(*1.25) mlabc(gs8)) ///
       (pcspike captured_index year ones year, horizontal lw(*14) lc(`c1')) ///
	   (pcspike killed_index year ones year, horizontal lw(*7) lc(`c2')) ///
	   (scatter year captured_index if year!=2001 & captured_index>1, `sc1' mlab(captured_str) mlabpos(3) mlabcolor(`c1')) ///
	   (scatter year ones if year!=2001 & captured_index<1, `sc1' mlab(captured_str) mlabpos(3) mlabcolor(`c1')) ///
       (scatter year killed_index if year!=2001, `sc1' mlab(killed_str) mlabpos(9) mlabcolor(`c2')) ///
	   (scatteri 2019 `=xbound' "{bf:Captured index}", ms(i) mlabc(`c1') mlabgap(-7) mlabpos(9)) ///
	   (scatteri 2019 `=-xbound+2' "{bf:Killed index}", ms(i) mlabc(`c2') mlabgap(-7) mlabpos(3)) ///
	   (pcarrowi 2001 1.2 2001 2, lc(gs8) mc(gs8) barbsize(medium)) ///
	   (pcarrowi 2001 0.8 2001 0, lc(gs8) mc(gs8) barbsize(medium)) ///
	   (scatteri 2001 2 `"{fontface "Palatino":{it:increases}}"', ms(i) mlabc(gs8) mlabgap(1) mlabpos(3)) ///
	   (scatteri 2001 0 `"{fontface "Palatino":{it:decreases}}"', ms(i) mlabc(gs8) mlabgap(1) mlabpos(9)) ///
	    , legend(off) ysize(1.5) xsize(1) ytitle("") xtitle("") yscale(lc(none)) ///
	   xscale(range(`=-xbound+2' `=xbound') lc(none)) xlabel(none) ///
	   ylabel(2001/2018 2019 " ", angle(0) labsize(*.8) noticks labc(gs8) grid glw(*14) glc(gs15%50)) ///
	   plotregion(margin(b=2 t=0 l=8 r=8) lc(none) lw(*1.5)) ///
	   graphregion(margin(r+5 l+5) lc(gs8) lw(*.5)) ///
	   title("Taiji Cove hunting seasons", size(*.75) margin(b=1)) ///
       subtitle("Index of small cetaceans killed and captured (base year 2001)", size(*.75) margin(b+5)) ///
	   note(`"{fontface "Palatino":Data source: http://au.whales.org; 2017-2018 from www.cetabase.org.}"', size(*.85) c(gs8) margin(t+2))
graph export taijicove_index.png, replace


exit

Data source: http://au.whales.org/issues/dolphin-hunts-focus-on-taiji-japan

