/*
 Demetris Christodoulou
 demetris.christodoulou@sydney.edu.au
 Graph Workflow ©
 www.graphworkflow.com
*/

version 15
cd "/Users/dchristodoulou/Documents/research/graphworklfow.com/graphs/taiji_cove"
graph set window fontface "Avenir"
graph set window fontfaceserif "Palatino"

clear
use taijicove

// data management
generate total = killed + captured

sort year
generate killed_index = (killed[_n]/killed[1])*1
generate captured_index = (captured[_n]/captured[1])*1

// first pass
line total captured year, scheme(lean2)
graph export taiji_default.png,replace

// graph management
generate labvar = 3
replace  labvar = 4 if inlist(year,2013,2015)
replace  labvar = 2 if inlist(year,2009,2012,2014,2016,2017)

qui sum captured if year==2001
scalar cap2001 = r(mean)
qui sum captured if year==2018
scalar cap2018 = r(mean)
qui sum total if year==2018
scalar tot2018 = r(mean)

qui sum total if year==2009
scalar y1 = r(mean)
scalar x1 = 2009
qui sum total if year==2014
scalar y2 = r(mean)
scalar x2 = 2014

local si1 recast(line) ms(i) lc(dkorange) lw(*1.5)
local si2 ms(O) mlw(*2) mfc(dkorange) mlc(navy)
local si3 ms(o) mc(none) mlabsize(2) mlabc(dkorange) mlabpos(3)
local si4 ms(o) mc(none) mlabsize(2) mlabc(navy)
local sc1 ms(O) mlw(*1.5) msize(*.75) mfc(gs16) mlc(navy)
local sc2 ms(O) mlw(*.75) msize(*.75) mfc(gs16) mlc(navy*1.5)
twoway (scatteri `=y1' `=x1' `=y1+250' `=x1' `=y1+250' `=x1+.25', `si1') ///
       (scatteri `=y2' `=x2' `=y2+250' `=x2' `=y2+250' `=x2+.25', `si1') ///
       (area total captured year, fc(navy%10 navy*1.5%15) lw(*.1 *.1)) ///
       (line total captured year, lc(navy navy*1.5) lw(*2 *1)) ///
       (scatter total year if year!=2018 ///
	    , `sc1' mlab(total) mlabsize(2) mlabgap(*1) mlabc(navy) mlabvpos(labvar)) ///
       (scatter total year if year==2018, `sc1') ///
       (scatter captured year if inlist(year,2001,2018), `sc2') ///
       (scatter captured year if inlist(year,2011,2013,2016,2017) ///
	    , `sc2' mlab(captured) mlabsize(2) mlabgap(*1) mlabc(navy*1.5) mlabpos(1)) ///
       (scatteri `=y1' `=x1', `si2') ///
       (scatteri `=y2' `=x2', `si2') ///
       (scatteri `=y1+250' `=x1+.25' "{bf:The Cove doc is released}", `si3') ///
       (scatteri `=y2+250' `=x2+.25' "{bf:Action for Dolphins lawsuit}", `si3') ///
       (scatteri `=cap2001' 2001 "`=cap2001'", `si4' mlabpos(9)) ///
       (scatteri `=cap2018' 2018 "`=cap2018' captured", `si4' mlabpos(3)) ///
       (scatteri `=tot2018' 2018 "`=tot2018' killed and captured", `si4' mlabpos(3)) ///
       , legend(off) scale(1.1) ysize(1) xsize(2.2) ///
	   xtitle("") yscale(lc(none) ) ///
	   xlabel(2001/2020, grid glw(*.2) tlw(*.5) tlen(*.5) labsize(2)) ///
       ylabel(0 "0", angle(0) labsize(2) tlw(*.5) tlen(*.5) ) ytitle("") ///
	   plotregion(margin(b=0 t=0 l=0 r=0) lc(none) lw(*1.5)) ///
	   graphregion(margin(r+5 l+5) lc(gs8) lw(*.5)) ///
	   title("Taiji Cove hunting seasons: Number of small cetaceans killed and captured", size(*.75) margin(b=1)) ///
	   note(`"{fontface "Minion Pro":Data source: 2001-2016 data from http://au.whales.org/issues/dolphin-hunts-focus-on-taiji-japan. 2017-2018 data from http://www.cetabase.org/taiji/drive-results/.}"')
graph export taijicove.png, replace

exit


Data source: http://au.whales.org/issues/dolphin-hunts-focus-on-taiji-japan

