/*
 Demetris Christodoulou
 demetris.christodoulou@sydney.edu.au
 Graph Workflow ©
 www.graphworkflow.com
*/


version 15
cd "/Users/dchristodoulou/Documents/research/graphworklfow.com/graphs/us_income_tax"
graph set window fontface "Avenir"
graph set window fontfaceserif "Palatino"
graph set window fontfacesans "Century Gothic Regular"

clear all
use us_tax

// data management
generate total = individual + corporate + social + excise + other
generate c_i = individual/total
generate c_c = corporate/total  + c_i
generate c_s = social/total     + c_c
generate c_e = excise/total     + c_s
generate c_o = other/total      + c_e


// first pass
twoway (area c_o year) (area c_e year) ///
       (area c_s year) (area c_c year) ///
	   (area c_i year), scheme(s1color)
graph export us_income_tax_area_default.png,replace


// graph management
qui sum year
local yearmin = r(min)
local yearmax = r(max)
local ylab0 ""
local ylab1 ""
foreach i of varlist c_* {
   if "`i'"!="c_s" { 
      qui sum `i' if year==`yearmin'
      scalar `i'0 = r(mean)
   }
   qui sum `i' if year==`yearmax'
   scalar `i'1 = r(mean)
   local ylab0 `ylab0' `=`i'0'
   local ylab1 `ylab1' `=`i'1'
}

local sc1 msymbol(i) mlabcolor(gs2)
local ylb angle(0) format(%03.2f) labsize(*.6) noticks
twoway (area c_o year, fcolor(orange*.65) lcolor(gs16) yaxis(1 2)) ///
       (area c_e year, fcolor(forest_green*.65) lcolor(gs16)) ///
       (area c_s year, fcolor(gs12) lcolor(gs16)) ///
       (area c_c year, fcolor(red*.65) lcolor(gs16)) ///
       (area c_i year, fcolor(navy*.65) lcolor(gs16)) ///
       (scatteri 0 2018 1 2018 1 2023 0 2023 0 2018, recast(area) lw(*.1) lc(gs16%40) fc(gs16%40)) ///
       (scatteri 0 2018 1 2018, recast(line) lcolor(gs16)) ///
       (scatteri .95 1935 "Other", `sc1') ///
       (scatteri .90 1947 "Excise tax", `sc1') ///
       (scatteri .75 1970 "Social insurance and retirement receipts", `sc1') ///
       (scatteri .55 1950 "Corporation income tax", `sc1') ///
       (scatteri .20 1950 "Individual income tax", `sc1') ///
       (scatteri .15 2020 "{it:estimates}", msymbol(i) mlabcolor(gs16) mlabpos(0) mlabangle(90)) ///
       , legend(off) ysize(1) xsize(2) ///
       title("Composition of US Federal receipts by source",  pos(11) margin(b+2) size(*.75)) ///
       note("{stSerif:Data Source: The White House Office of Management and Budget.}", size(*.85) margin(t+2)) ///
       xlabel(1934 1940(10)2010 2018 2023, labsize(*.75)) ///
       ylabel(0 "0" `ylab0', axis(1) `ylb') ///
       ylabel(0 "0" `ylab1', axis(2) `ylb') ///
       plotregion(margin(l=0 t=.2 b=0 r=.2) lcolor(gs0) lwidth(*1.5)) ///
       graphregion(margin(r+2) lc(gs8) lw(*.5)) ///
       ytitle("Cumulative percentage")
graph export us_income_tax_area.png,replace


generate p_ind = individual/total
generate p_cor = corporate/total
generate diff = p_ind - p_cor
separate diff, by(diff>=0)
replace  diff0 = diff0[_n+1] if diff0[_n]==. & diff0[_n+1]!=.
replace  diff1 = diff1[_n+1] if diff1[_n]==. & diff1[_n+1]!=.

qui sum diff0
scalar ymin = r(min)
qui sum diff1
scalar ymax = r(max)
local sc1 recast(line) lc(gs16) lw(*.75)
local sc2 ms(i) mlabpos(3) mlabcol(gs0) mlabsize(*.85)
twoway (area diff0 year, fc(red*.65) lc(gs0)  lw(*.25) cmissing(n)) ///
       (area diff1 year if year<=2018, fc(navy*.85) lc(gs0) lw(*.25) cmissing(n)) ///
       (area diff1 year if year>=2018, fc(navy*.45) lc(gs0) lw(*.25) cmissing(n)) ///
       (scatteri 0 1945 .42 1945, `sc1') ///
       (scatteri 0 1953 .42 1953, `sc1') ///
       (scatteri 0 1961 .42 1961, `sc1') ///
       (scatteri 0 1963 .42 1963, `sc1') ///
       (scatteri 0 1969 .42 1969, `sc1') ///
       (scatteri 0 1974 .42 1974, `sc1') ///
       (scatteri 0 1977 .42 1977, `sc1') ///
       (scatteri 0 1981 .42 1981, `sc1') ///
       (scatteri 0 1989 .42 1989, `sc1') ///
       (scatteri 0 1993 .42 1993, `sc1') ///
       (scatteri 0 2001 .42 2001, `sc1') ///
       (scatteri 0 2009 .42 2009, `sc1') ///
       (scatteri 0 2017 .42 2017, `sc1') ///
       (scatteri -.15 1936.9 "{stSans:Roosevelt}", `sc2') ///
       (scatteri -.15 1947.0 "{stSans:Truman}", `sc2') ///
       (scatteri -.15 1954.0 "{stSans:Eisenhower}", `sc2') ///
       (scatteri -.15 1960.9 "{stSans:JFK}", `sc2' mlabgap(*.01)) ///
       (scatteri -.15 1963.7 "{stSans:Johnson}", `sc2') ///
       (scatteri -.15 1969.6 "{stSans:Nixon}", `sc2') ///
       (scatteri -.15 1974.1 "{stSans:Ford}", `sc2' mlabgap(*.5)) ///
       (scatteri -.15 1977.2 "{stSans:Carter}", `sc2') ///
       (scatteri -.15 1983.0 "{stSans:Reagan}", `sc2' mlabgap(*.5)) ///
       (scatteri -.15 1989.3 "{stSans:Bush}",`sc2') ///
       (scatteri -.15 1995.0 "{stSans:Clinton}", `sc2') ///
       (scatteri -.15 2002.5 "{stSans:G.W.Bush}", `sc2') ///
       (scatteri -.15 2011.0 "{stSans:Obama}", `sc2' mlabgap(*.5)) ///
       (scatteri -.15 2017.2 "{stSans:Trump}", `sc2' mlabgap(*.5)) ///
       (scatteri  .02 2020 "{it:estimates}", msymbol(i) mlabc(gs16) mlabsize(*1.1) mlabpos(3) mlabangle(90)) ///
       , legend(off) ///
       ysize(1) xsize(2.5) ///
       title("US Federal receipts: Individual tax net of Corporate tax", ring(1) size(*.85) pos(11)) ///
       note("{stSerif:Data Source: The White House Office of Management and Budget.}", size(*.85) margin(t+2)) ///
       xlabel(1934 1945 1953 1961 "1961  " 1963 "  1963" 1969 1974  ///
              1977 1981 1989 1993 2001 2009 2017 2023 ///
              , labsize(*.75) grid glcolor(gs16)) ///
       ylabel(0 "0" `=ymin' `=ymax', angle(0) format(%04.2f) labsize(*.75)) ///
       plotregion(margin(l=0 t+1 b-1 r=.3) lcolor(gs0) fcolor(navy*.15)) ///
       graphregion(margin(r+2) lc(gs8) lw(*.5)) ///
       ytitle("Net portion ( individual tax - corporate tax )", size(*.85))
graph export us_income_tax_diff.png,replace

exit


Note: 2018 onwards are estimates
